<?php 
$page_title = "Dashboard";
include("includes/header.php");
require("includes/lb_helper.php");

$cliente = isset($_SESSION['admin_name']) ? $_SESSION['admin_name'] : '';  // Obtiene el nombre del cliente desde la sesión

// Comprobar si el cliente está registrado en la sesión
if (!$cliente) {
    echo "No se ha encontrado un cliente asociado a la sesión.";
    exit;
}

// Contar el número de administradores
$qry_admin = "SELECT COUNT(*) as num FROM tbl_admin";
$total_admin = mysqli_fetch_array(mysqli_query($mysqli, $qry_admin));
$total_admin = $total_admin['num'];

// Contar el número de DNS de **todos los clientes**
$qry_dns_all = "SELECT COUNT(*) as num FROM tbl_dns";  // NO FILTRAR POR CLIENTE
$total_dns_all = mysqli_fetch_array(mysqli_query($mysqli, $qry_dns_all));
$total_dns_all = $total_dns_all['num'];

// Contar el número de DNS del cliente actual
$qry_dns_cliente = "SELECT COUNT(*) as num FROM tbl_dns WHERE cliente = '$cliente'";  // Filtrado por cliente
$total_dns_cliente = mysqli_fetch_array(mysqli_query($mysqli, $qry_dns_cliente));
$total_dns_cliente = $total_dns_cliente['num'];

// Contar el número de reportes
$qry_re = "SELECT COUNT(*) as num FROM tbl_reports";
$total_reports = mysqli_fetch_array(mysqli_query($mysqli, $qry_re));
$total_reports = $total_reports['num'];

// Contar el número de notificaciones
$qry_notification = "SELECT COUNT(*) as num FROM tbl_notification";
$total_notification = mysqli_fetch_array(mysqli_query($mysqli, $qry_notification));
$total_notification = $total_notification['num'];

// Obtener los últimos reportes
$sql_reports = "SELECT * FROM tbl_reports ORDER BY tbl_reports.`id` DESC LIMIT 10";
$result_reports = mysqli_query($mysqli, $sql_reports);

// Obtener los datos de configuración
$qry = "SELECT * FROM tbl_settings WHERE id = '1'";
$result = mysqli_query($mysqli, $qry);
$settings_data = mysqli_fetch_assoc($result);

?>

<!-- Start: main -->
<main id="nsofts_main">
    <div class="nsofts-container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item d-inline-flex"><a href="dashboard.php"><i class="ri-home-4-fill"></i></a></li>
                <li class="breadcrumb-item d-inline-flex active" aria-current="page"><?php echo (isset($page_title)) ? $page_title : ""; ?></li>
            </ol>
        </nav>
        
        <div class="row g-4">
            <style>
                .nsofts-icon i {
                    font-size: 45px;
                }
                .social_img {
                    position: absolute;
                    width: 20px !important;
                    height: 20px !important;
                    z-index: 1;
                    left: 13px;
                }
            </style>
                
            <?php if (isset($_SESSION['admin_type'])) { ?>
                <?php if ($_SESSION['admin_type'] != 0) { ?>
                    <div class="col-xxl-3 col-md-6">
                        <div class="card card-raised border-start border-primary border-4">
                            <div class="card-body px-4">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="me-2">
                                        <div class="display-6"><?php echo thousandsNumberFormat($total_admin); ?></div>
                                        <div class="d-block mb-1 text-muted">Clientes</div>
                                    </div>
                                    <div class="d-inline-flex text-primary nsofts-icon"><i class="ri-admin-line"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                                <!-- Tarjeta para mostrar el total de DNS de todos los clientes -->

                        <div class="col-xxl-3 col-md-6">
                <div class="card card-raised border-start border-info border-4">
                    <div class="card-body px-4">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="me-2">
                                <div class="display-6"><?php echo thousandsNumberFormat($total_dns_all); ?></div>
                                <div class="d-block mb-1 text-muted">DNS (Todos los clientes)</div>
                            </div>
                            <div class="d-inline-flex text-info nsofts-icon "><i class="ri-links-line"></i></div>
                        </div>
                    </div>
                </div>
            </div>
                <?php } ?>
            <?php } ?>
            
        

            <!-- Tarjeta para mostrar el total de DNS del cliente actual -->
            <div class="col-xxl-3 col-md-6">
                <div class="card card-raised border-start border-info border-4">
                    <div class="card-body px-4">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="me-2">
                                <div class="display-6"><?php echo thousandsNumberFormat($total_dns_cliente); ?></div>
                                <div class="d-block mb-1 text-muted">DNS Admin</div>
                            </div>
                            <div class="d-inline-flex text-info nsofts-icon "><i class="ri-links-line"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row g-4 mt-2">
        </div>
    </div>
</main>
<!-- End: main -->

<?php include("includes/footer.php"); ?>
